/*******************************************************************
*
*  DESCRIPTION: Atomic Model MotorR
*
*  AUTHOR: Dieynaba Alpha Tall
*
*  EMAIL: alphadieynaba@yahoo.fr
*
*
*  DATE: 07/07/2009
*
*******************************************************************/

#ifndef __MOTOR_H
#define __MOTOR_H

/** include files **/
#include "atomic.h"     // class Atomic
#include "string.h"	// class String

/** declarations **/
class Motor : public Atomic
{
public:
	Motor( const std::string &name = "Motor" ); //Default constructor
	virtual std::string className() const {  return "Motor" ;}
	~Motor();


protected:

	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &motor_in;
	Port &motor_out;
	
	Time movePrepTime;	//prep time_advance to Stop or move Fwd/Rev

	int move_dir; // value of port
	
	enum State{         //to keep current state of the Compass1
		STOP,      //initial state
		PREP_MOVE_FWD,    // prepare to move forward
		PREP_MOVE_REV,// prepare to move backward
		MOVE_FWD,  // move forward
		MOVE_REV,  //move backward
		PREP_STOP    // prepare to stop
	} state;

};	// class MotorR

#endif   //__MOTOR2_H
